% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_exclude_col}
\alias{df_exclude_col}
\title{Remove columns from data.frame}
\usage{
df_exclude_col(df, col, on_missing_col = "warn")
}
\arguments{
\item{df}{data.frame, input data.frame}

\item{col}{character vector, column name(s) to be deleted}

\item{on_missing_col}{string, behavior for missing column(s):
"warn" - log warning, "skip" - skip missing column(s), "stop" - throw error}
}
\value{
Modified input data.frame
}
\description{
Remove columns from data.frame
}
\examples{
df <- data.frame(a = 1:3, b = 1:3, c = 1:3)
df_exclude_col(df, "b")
df_exclude_col(df, c("a", "c"))

}
