% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oblique_survival_forest_print.R
\name{print.orsf}
\alias{print.orsf}
\title{Grow an oblique random survival forest (ORSF)}
\usage{
\method{print}{orsf}(x, ...)
}
\arguments{
\item{x}{an ORSF object (i.e. the object returned from the ORSF function)}

\item{...}{additional arguments passed to print}
}
\value{
A printed summary of the oblique random survival forest.
}
\description{
Grow an oblique random survival forest (ORSF)
}
\examples{
\dontrun{
data("pbc",package='survival')
pbc$status[pbc$status>=1]=pbc$status[pbc$status>=1]-1
pbc$id=NULL
fctrs<-c('trt','ascites','spiders','edema','hepato','stage')
for(f in fctrs)pbc[[f]]=as.factor(pbc[[f]])
pbc=na.omit(pbc)

orsf=ORSF(data=pbc,ntree=30)
print(orsf)
}
}
