% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occCite_plotting.R
\name{sumFig.occCite}
\alias{sumFig.occCite}
\title{Generating summary figures for occCite search results}
\usage{
sumFig.occCite(
  occCiteData,
  bySpecies = FALSE,
  plotTypes = c("yearHistogram", "source", "aggregator")
)
}
\arguments{
\item{occCiteData}{An object of class \code{\link{occCiteData}} to
map.}

\item{bySpecies}{Logical; setting to `TRUE` generates the desired
plots for each species.}

\item{plotTypes}{The type of plot to be generated; "yearHistogram",
"source", and/or "aggregator".}
}
\value{
A list containing the desired plots.
}
\description{
Generates up to three different kinds of plots,
with toggles determining whether plots should be done for
individual species or aggregating all species--histogram
by year of occurrence records, waffle::waffle plot of primary
data sources, waffle::waffle plot of data aggregators.
}
\examples{
data(myOccCiteObject)
sumFig.occCite(myOccCiteObject, bySpecies = FALSE,
               plotType = c("yearHistogram", "source", "aggregator"))

}
