% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\name{read.topo}
\alias{read.topo}
\title{Read a Topo File}
\usage{
read.topo(file, ...)
}
\arguments{
\item{file}{Name of a file containing an ETOPO-format dataset.}

\item{\dots}{Additional arguments, passed to called routines.}
}
\value{
An object of type \code{\link{topo-class}} that which has the following slots.
\item{\code{data}}{: a data frame containing \code{lat}, \code{lon}, and
  \code{z}}
\item{\code{metadata}}{: a list containing the source filename}
\item{\code{processingLog}}{: a log, in the standard \code{oce} format.}
}
\description{
Read a file that contains topographic data in the ETOPO dataset, as provided by
the NOAA website [1].
}
\examples{
\dontrun{
library(oce)
topoMaritimes <- read.topo("topoMaritimes.asc")
plot(topographyMaritimes)
}

}
\author{
Dan Kelley
}
\references{
1. NOAA website that provides datasets:
\url{http://maps.ngdc.noaa.gov/viewers/wcs-client} with the \code{ArcGIS ASCII
  Grid} menu item selected.
}
\seealso{
Other things related to \code{topo} data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{plot,topo-method}},
  \code{\link{subset,topo-method}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}},
  \code{\link{topoWorld}}
}

