% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\docType{methods}
\name{subset,coastline-method}
\alias{subset,coastline-method}
\title{Subset a Coastline Object}
\usage{
\S4method{subset}{coastline}(x, subset, ...)
}
\arguments{
\item{x}{A \code{coastline} object, i.e. one inheriting from \code{\link{coastline-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{...}{Ignored.}
}
\value{
A \code{coastline} object.
}
\description{
Summarizes coastline length, bounding box, etc.
}
\seealso{
Other things related to \code{coastline} data: \code{\link{[[,coastline-method}},
  \code{\link{[[<-,coastline-method}},
  \code{\link{as.coastline}},
  \code{\link{coastline-class}},
  \code{\link{coastlineBest}}, \code{\link{coastlineCut}},
  \code{\link{coastlineWorld}},
  \code{\link{download.coastline}},
  \code{\link{plot,coastline-method}},
  \code{\link{read.coastline.openstreetmap}},
  \code{\link{read.coastline.shapefile}},
  \code{\link{summary,coastline-method}}
}
\author{
Dan Kelley
}
