% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisst.R
\docType{class}
\name{lisst-class}
\alias{lisst-class}
\title{Class to Store LISST Data}
\description{
Class to store LISST (Laser in-situ scattering and transmissometry) data.
}
\details{
One may read \code{lisst} objects with \code{\link{read.lisst}},
generate them with \code{\link{as.lisst}}, plot them
with \code{\link{plot,lisst-method}}, and summarize them with
\code{\link{summary,lisst-method}}. Elements may be extracted
with \code{\link{[[,lisst-method}} or replaced with
\code{\link{[[<-,lisst-method}}.
}
\references{
A users's manual for the LISST-100 instrument is available at
the manufacturer's website \url{http://www.sequoiasci.com}.
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lobo-class}}, \code{\link{met-class}},
  \code{\link{oce-class}}, \code{\link{odf-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{lisst} data: \code{\link{[[,lisst-method}},
  \code{\link{[[<-,lisst-method}}, \code{\link{as.lisst}},
  \code{\link{plot,lisst-method}},
  \code{\link{read.lisst}},
  \code{\link{summary,lisst-method}}
}
\author{
Dan Kelley
}
