% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapCoordinateSystem}
\alias{mapCoordinateSystem}
\title{Draw a coordinate system}
\usage{
mapCoordinateSystem(longitude, latitude, L = 100, phi = 0, ...)
}
\arguments{
\item{longitude}{numeric value of longitude in degrees.}

\item{latitude}{numeric value of latitude in degrees.}

\item{L}{axis length in km.}

\item{phi}{angle, in degrees counterclockwise, that the "x" axis makes to a line of latitude.}

\item{...}{plotting arguments, passed to \code{\link{mapArrows}};
see \dQuote{Examples} for how to control the arrow-head size.}
}
\description{
Draws arrows on a map to indicate a coordinate system, e.g. for an
to indicate a coordinate system set up so that one axis is parallel
to a coastline.
}
\details{
This is a preliminary version of this function. It only
works if the lines of constant latitude are horizontal on the plot.
}
\examples{
\donttest{
library(oce)
data(coastlineWorldFine, package='ocedata')
HfxLon <- -63.5752
HfxLat <- 44.6488
mapPlot(coastlineWorldFine, proj='+proj=merc',
        longitudelim=HfxLon+c(-2,2), latitudelim=HfxLat+c(-2,2),
        col='lightgrey')
mapCoordinateSystem(HfxLon, HfxLat, phi=45, length=0.05)
}

}
\author{
Chantelle Layton
}
