% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.ad2cp.R
\name{read.adp.ad2cp}
\alias{read.adp.ad2cp}
\title{Read a Nortek AD2CP File}
\usage{
read.adp.ad2cp(
  file,
  from = 1,
  to = 0,
  by = 1,
  which = "all",
  tz = getOption("oceTz"),
  ignoreChecksums = FALSE,
  longitude = NA,
  latitude = NA,
  orientation,
  distance,
  plan,
  type,
  monitor = FALSE,
  despike = FALSE,
  processingLog,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{from}{an integer indicating the index number of the first record to
read. This must equal 1, for this version of \code{read.adp.ad2cp}.  (If not
provided, \code{from} defaults to 1.)}

\item{to}{an integer indicating the final record to read. If \code{to} is 0L,
which is the default, then the value is changed internally to 1e9, and
reading stops at the end of the file.}

\item{by}{ignored.}

\item{which}{a character value indicating the data type(s) to be read, and
stored in the \code{data} slot of the returned value.  The default, \code{which="all"},
means to read all the types.  In many cases, though, the user does not want
to read everything at once, either as a way to speed processing or to avoid
running out of memory.  For this reason, a common first step is instead to
use \code{which="?"}, which gives a table of data types in the file or
\code{which="??"}, which gives a data frame summarizing the data 'chunks'; after
doing those things, the next step is usually to extract all the data, or an
individual type of interest is extracted.  The choices of individual type are
as follows:

\code{"burst"} for ID code 0x15,
\code{"average"} for ID code 0x16,
\code{"bottomTrack"} for ID code 0x17,
\code{"interleavedBurst"} for ID code 0x18,
\code{"burstAltimeterRaw"} for ID code 0x1a,
\code{"DVLBottomTrack"} for ID code 0x1b,
\code{"echosounder"} for ID code 0x1c,
\code{"DVLWaterTrack"} for ID code 0x1d,
\code{"altimeter"} for ID code 0x1e,
and
\code{"averageAltimeter"} for ID code 0x1f.}

\item{tz}{a character value indicating time zone. This is used in
interpreting times stored in the file.}

\item{ignoreChecksums}{a logical value indicating whether to ignore
checksums.  This is FALSE by default, meaning that any data chunk with an
improper checksum is ignored. It may be necessary to set this to TRUE to
parse some problematic files.}

\item{longitude, latitude}{numerical values indicating the observation
location.}

\item{orientation}{ignored by \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}}, and provided only for
similarity to other \verb{read.adp.*} functions.}

\item{distance}{ignored by \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}}, and provided only for similarity
to other \verb{read.adp.*} functions.}

\item{plan}{optional integer specifying which 'plan' to focus on (see
reference 1 for the meaning of 'plan').  If this is not given, it defaults to
the most common plan in the requested subset of the data.}

\item{type}{optional character value indicating the type of Nortek
instrument.  If this is not provided, an attempt is made to infer it from the
file header (if there is one), and \code{"Signature1000"} is used, otherwise. The
importance of knowing the type is for inferring the slantwise beam angle,
which is usd in the conversion from beam coordinates to xyz coordinates. If
\code{type} is provided, it must be one of \code{"Signature250"}, \code{"Signature500"}, or
\code{"Signature1000"}; the first of these has a 20 degree slant-beam angle, while
the others each have 20 degrees (see reference 2, section 2 on page 6). Note
that \code{\link[=oceSetMetadata]{oceSetMetadata()}} can be used to alter the slantwise beam angle of an
existing object, and this will alter any later conversion from beam to xyz
coordinates.}

\item{monitor}{a boolean value indicating whether to indicate the progress of
reading the file, by using \code{\link[=txtProgressBar]{txtProgressBar()}} or otherwise.  The value of
\code{monitor} is changed to \code{FALSE} automatically, for non-interactive sessions.}

\item{despike}{ignored by \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}}, and provided only for similarity
to other \verb{read.adp.*} functions.}

\item{processingLog}{a character value that, if provided, is saved within the
\code{processingLog} slot of the returned value.}

\item{debug}{an integer value indicating the level of debugging.  Set to 1 to
get a moderate amount of debugging information, from the R code only, to 2 to
get some debugging information from the C++ code that is used to parse the
data chunks, or to 3 for intensive debugging at both levels.}

\item{\dots}{ignored.}
}
\value{
An \linkS4class{adp} object with \code{metadata$fileType} equal to \code{"AD2CP"}, a
table (if \code{which="?"}), a data frame (if \code{which="??"}), or a vector of
character (if \code{which="text"}).
}
\description{
This function reads Nortek AD2CP files, storing data elements in lists within
the \code{data} slot.  Those elements are named for the ID type in question.  For
example, data with ID code \code{0x16} are stored in \code{data$average}; see
\code{\link[=ad2cpCodeToName]{ad2cpCodeToName()}} for the code mapping.
}
\details{
By default, \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} reads all ID codes that are in the file.
This can yield very large objects, so if only certain IDs are of interest,
try setting the \code{which} document accordingly.

It is important to realize that \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} is incomplete, and has not
been well tested.  The data format is not documented thoroughly in the
available Nortek manuals, and contradictions between the manuals require an
uncomfortable degree of guesswork; see \dQuote{Cautionary Notes}.
}
\section{Cautionary Notes}{


Early in the year 2022, support was added for 12-byte headers.  These are not
described in any Nortek document in the possession of the author of
\code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}}, although some personal communications made via
https://github.com/dankelley/oce/issues have exposed some clues that have led
to provisional, but largely untested, code here.

The \dQuote{References} section lists some manuals that were consulted during
the coding of `read.adp.ad2cp()].  Since instruments evolve over time, one
might think that Nortek (2022) would be the best place to start, in coding to
read AD2CP files. That would be a mistake, and a big one, at that. There
are two reasons for this.

First, Nortek (2022) is not as clear in its description of the data format as
Nortek (2017) and Nortek (2018), as exemplified by a few examples.
\enumerate{
\item Nortek (2022) has dropped the explanation of how to compute checksums,
which was present in the earlier documents.
\item The Nortek (2022) explanation of the data format differs from the older
explanations and is arguably more difficult to understand.  With the new
leading-underscore format (see Nortek 2022, page 79), information is spread
throughout the document, making it challenging to understand data fields in
isolation.  The older documents laid things out more clearly, e.g. the
average/burst format is laid out in detail, \emph{in one place} on pages 57 to 64
of Nortek, with the optional fields being clearly labelled in the rightmost
column of Table 6.1.3.
\item Nortek (2022) does not always specify units correctly.  For example, on
page 82, Pressure is said to have "Unit [dBar]" in green text, but the
black text above states "Raw data given as 0.001 dBar". If the stated storage
class (uint32) is to be believed, then it seems clear that the unit must be
0.001 dBar, so the green text should be ignored.  The same can be said of
items throughout the data-format tables. In coding `read.adp.ad2cp()], the
green "Unit" text was ignored in basically every case.
}

Second, Nortek (2022) contains significant errors, e.g. the following.
\enumerate{
\item Nortek (2022 page 89) states the storage class for "Altimeter
data. Altimeter distance" (called \code{AltimeterDistance} by the present function)
to be \code{int32}, but Nortek (2017, 2018) both state it to be \code{float32}. Tests
with actual datasets make it clear that the format is \code{float32}, since wild
result are inferred by following the Nortek (2022) guidance.
\item As above, but for "AST data.AST distance" (called \code{ASTDistance} by the
present function).
}
}

\examples{
# You can run this within the oce directory, if you clone from github.
file <- "tests/testthat/local_data/ad2cp/S102791A002_Barrow_v2.ad2cp"
if (file.exists(file)) {
    library(oce)
    d <- read.oce(file)
}

}
\references{
Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
2017.

Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
2018. (This revision includes new information about instrument orientation.)

Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
March 31, 2022.  (This version is incomplete and quite confusing,
so the 2017 and 2018 versions are preferable, albeit perhaps out-of-date.)
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}

Other things related to ad2cp data: 
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{is.ad2cp}()}

Other functions that read adp data: 
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()}
}
\author{
Dan Kelley
}
\concept{functions that read adp data}
\concept{things related to ad2cp data}
\concept{things related to adp data}
