% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{oceRenameData}
\alias{oceRenameData}
\title{Rename Something in an oce data Slot}
\usage{
oceRenameData(object, old, new, note = "")
}
\arguments{
\item{object}{an \linkS4class{oce} object.}

\item{old}{character value that matches the name of an item in \code{object}'s \code{data} slot.}

\item{new}{character value to be used as the new name that matches the name of an item in
\code{object}'s \code{data} slot. Thus must not be the name of something that is already in the \code{data}
slot. If \code{new} is the  same as \code{old}, then the object is returned unaltered.}

\item{note}{character value that holds an explanation of the reason for the change. If this
is a string of non-zero length, then this is inserted in the processing log of the returned
value. If it is \code{NULL}, then no entry is added to the processing log.  Otherwise, the processing
log gets a new item that is constructed from the function call.}
}
\description{
Rename an item within the \code{data} slot of an \linkS4class{oce} object, also changing
\code{dataNamesOriginal} in the \code{metadata} slot, so that the \code{[[} accessor will
still work with the original name that was stored in the data.
}
\examples{
library(oce)
data(ctd)
CTD <- oceRenameData(ctd, "salinity", "SALT")
stopifnot(all.equal(ctd[["salinity"]], CTD[["SALT"]]))
stopifnot(all.equal(ctd[["sal00"]], CTD[["SALT"]]))

}
\seealso{
Other things related to the data slot: 
\code{\link{oceDeleteData}()},
\code{\link{oceGetData}()},
\code{\link{oceSetData}()}
}
\author{
Dan Kelley
}
\concept{things related to the data slot}
