% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{plotScan}
\alias{plotScan}
\title{Plot CTD data in a Low-Level Fashion}
\usage{
plotScan(
  x,
  which = 1,
  xtype = "scan",
  flipy = FALSE,
  type = "l",
  mgp = getOption("oceMgp"),
  xlim = NULL,
  ylim = NULL,
  mar = c(mgp[1] + 1.5, mgp[1] + 1.5, mgp[1], mgp[1]),
  ...,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{which}{integer specifying the plot to be drawn: 1
for pressure vs 'x', 2 for \code{diff(pressure)} vs 'x', 3 for temperature vs
'x', and 4 for salinity vs 'x'  Here, the value of 'x' is determined by
\code{xtype}.}

\item{xtype}{Character string indicating variable for the x axis. The
permitted values are \code{"scan"} (the default), \code{"time"} and \code{"index"}.
The last of these is created by using \code{\link[=seq_along]{seq_along()}} on the pressure
column (which is assumed to be present in any \linkS4class{ctd} object).
Only \code{xtype="index"} is guaranteed to work for all objects, and indeed
that value is used, if either \code{"scan"} or \code{"time"} is requested, but
unavailable.}

\item{flipy}{Logical value, ignored unless \code{which} is 1. If \code{flipy}
is \code{TRUE}, then a pressure plot will have high pressures at the bottom
of the axis.}

\item{type}{Character indicating the line type, as for \code{\link[=plot.default]{plot.default()}}. The default
is \code{"l"}, meaning to connect data with line segments. Another good choice is
\code{"o"}, to add points at the data.}

\item{mgp}{Three-element numerical vector to use for \link{par}\code{(mgp)}, and also
for \link{par}\code{(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{xlim}{Limits on the x value. The default, \code{NULL}, is to select this
from the data.}

\item{ylim}{Limits on the y value. The default, \code{NULL}, is to select this
from the data.}

\item{mar}{Four-element vector be used with \link{par}\code{("mar")}.  If set
to \code{NULL}, then \link{par}\code{("mar")} is used.  A good choice for a TS diagram
with a palette to the right is \verb{mar=par("mar")+c(0, 0, 0, 1))}.}

\item{...}{Optional arguments passed to plotting functions.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Plot CTD data as time-series against scan number, to help with trimming
extraneous data from a CTD cast.
}
\section{Historical Note}{

On 2022-12-07, \code{xtype} was expanded to include \code{"index"}, and
an undocumented multi-panel feature was removed.
}

\examples{
library(oce)
data(ctdRaw)
plotScan(ctdRaw)
abline(v=c(130, 350), col="red") # useful for ctdTrim()

}
\seealso{
Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to ctd data}
