% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceSimple.R
\name{oceSimple}
\alias{oceSimple}
\title{Estimate win ratio or Mann-Whitney parameter using Simple Method}
\usage{
oceSimple(oceData, oceCoxOutput = NULL)
}
\arguments{
\item{oceData}{output from \code{\link{oceFormat}}.}

\item{oceCoxOutput}{output from \code{\link{oceCoxph}}, if NULL recalculates
using \code{oceData} and \code{\link{oceCoxph}}.}
}
\value{
A list with the following elements (where Yg=ordered composite
  endpoint score for group=g):
\describe{
 \item{int01}{estimate of P[Y0>Y1] (calculated from \code{\link{oceCoxph}})}
 \item{int10}{estimate of P[Y1>Y0] (calculated from \code{\link{oceCoxph}})}
 \item{WR}{win ratio, estimate of P[Y1>Y0]/P[Y0>Y1]}
 \item{MW}{desirability of outcome ranking,
   estimate of P[Y1>Y0]+(1/2)P[Y1=Y0]}
 }
}
\description{
Usually called from within \code{\link{oceTest}}.
Estimation done using simple method and output from \code{\link{oceCoxph}}.
}
