% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensorsplat.R
\name{tensorsplat}
\alias{tensorsplat}
\title{Implements Danai Koutra's TensorSplat algorithm}
\usage{
tensorsplat(matlist, k = 2, alpha = 0.05)
}
\arguments{
\item{matlist}{The list of matrices where each matrix denotes the adjacency matrix of the network.}

\item{k}{The number of components in PARFAC tensor decomposition.}

\item{alpha}{The threshold to declare anomalies}
}
\value{
Anomalous observations
}
\description{
Implements Danai Koutra's TensorSplat algorithm
}
\examples{
# We generate a series of networks and add an anomaly at 50th network.
set.seed(1)
networks <- list()
p.or.m.seq <- rep(0.05, 50)
p.or.m.seq[20] <- 0.2  # anomalous network at 20
for(i in 1:100){
  gr <- igraph::erdos.renyi.game(100, p.or.m = p.or.m.seq[i])
  networks[[i]] <- igraph::as_adjacency_matrix(gr)
}
tensobj <- tensorsplat(networks, k = 2)
tensobj  # anomalous networks


}
\references{
Koutra, D., Papalexakis, E. E., & Faloutsos, C. (2012).
TensorSplat: Spotting latent anomalies in time. Proceedings of the 2012 16th
Panhellenic Conference on Informatics, PCI 2012, 144–149.
https://doi.org/10.1109/PCi.2012.60
}
