% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.funs.R
\name{no.plot}
\alias{no.plot}
\title{Suppress plotting output of 'plot()' function}
\usage{
no.plot(model)
}
\arguments{
\item{model}{A fitted GAM(M).}
}
\description{
This function suppresses plotting output of 'plot()' function
}
\details{
To prevent unwanted plot printing of 'plot()' in a function call 
in which the only desire is to work with the returned information of 'plot()'.
Used in \code{\link[oddsratio]{pl.smooth.gam}}.
}
\examples{
# load data (Source: ?mgcv::gam)
library(mgcv)
n <- 200
sig <- 2
dat <- gamSim(1, n = n, scale = sig, verbose = FALSE)
dat$x4 <- as.factor(c(rep("A", 50), rep("B", 50), rep("C", 50), rep("D", 50)))
fit.gam <- gam(y ~ s(x0) + s(I(x1^2)) + s(x2) + 
               offset(x3) + x4, data = dat) # fit model
               
tmp <- plot(fit.gam, pages = 1) # plot output 
tmp <- no.plot(fit.gam) # no plot output 
}
\author{
Patrick Schratz <patrick.schratz@gmail.com>
}
\seealso{
\code{\link[oddsratio]{pl.smooth.gam}}
}
\keyword{internal}

