% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add_chunk.R
\name{slip_in_img}
\alias{slip_in_img}
\title{append an image}
\usage{
slip_in_img(x, src, style = "Normal", width, height, pos = "after")
}
\arguments{
\item{x}{a docx device}

\item{src}{image filename}

\item{style}{text style}

\item{width}{height in inches}

\item{height}{height in inches}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}
}
\description{
append an image into a paragraph of a docx object
}
\examples{
library(magrittr)
img.file <- file.path( Sys.getenv("R_HOME"), "doc", "html", "logo.jpg" )
read_docx() \%>\%
  body_add_par("R logo: ", style = "Normal") \%>\%
  slip_in_img(src = img.file, style = "strong", width = .3, height = .3) \%>\%
  print(target = "append_img.docx")
}
