% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with.R, R/ppt_ph_with_at.R
\name{ph_empty}
\alias{ph_empty}
\alias{ph_empty_at}
\title{add a new empty shape}
\usage{
ph_empty(x, type = "title", index = 1)

ph_empty_at(x, left, top, width, height, bg = "transparent", rot = 0,
  template_type = NULL, template_index = 1)
}
\arguments{
\item{x}{a pptx device}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.}

\item{left, top}{location of the new shape on the slide}

\item{width, height}{shape size in inches}

\item{bg}{background color}

\item{rot}{rotation angle}

\item{template_type}{placeholder template type. If used, the new shape will
inherit the style from the placeholder template. If not used, no text
property is defined and for example text lists will not be indented.}

\item{template_index}{placeholder template index (integer). To be used when a placeholder
template type is not unique in the current slide, e.g. two placeholders with
type 'body'.}
}
\description{
add a new empty shape in the current slide.
}
\examples{
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_empty(x = doc, type = "title")

print(doc, target = fileout )

# demo ph_empty_at ------
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_empty_at(x = doc, left = 1, top = 2, width = 5, height = 4)

print(doc, target = fileout )
}
