% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_wordtext}
\alias{run_wordtext}
\title{Word chunk of text with a style}
\usage{
run_wordtext(text, style_id = NULL)
}
\arguments{
\item{text}{text value, a single character value}

\item{style_id}{'Word' unique style identifier associated with the style to use.}
}
\description{
Format a chunk of text associated with a 'Word' character style.
The style is defined with its unique identifer.
}
\examples{
run1 <- run_wordtext("hello", "DefaultParagraphFont")
paragraph <- fpar(run1)

x <- read_docx()
x <- body_add_fpar(x, paragraph)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
\code{\link[=ftext]{ftext()}}

Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnote}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()}
}
\concept{run functions for reporting}
