% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_uniprot_data}
\alias{parse_uniprot_data}
\title{Parse UniProt Data}
\usage{
parse_uniprot_data(uniprot_data)
}
\arguments{
\item{uniprot_data}{A list returned by the UniProt API query.}
}
\value{
A list containing `entry_name`, `protein_name`, and `gene_name`.
}
\description{
This function parses the data retrieved from the UniProt API to extract
the entry name, protein name, and gene name.
}
\examples{
# Example usage:
\donttest{
# Retrieve UniProt data
test_result <- retrieve_uniprot_data("O88737")

# Parse the UniProt data
parsed_result <- parse_uniprot_data(test_result)

# Print the parsed result
print(parsed_result)
}
}
