% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isTRUENA.r
\name{isTRUENA}
\alias{isTRUENA}
\alias{isFALSENA}
\title{Vectorized test for truth robust to NA}
\usage{
isTRUENA(x, ifNA = FALSE)

isFALSENA(x, ifNA = FALSE)
}
\arguments{
\item{x}{Single value or condition or a vector of values to evaluate.}

\item{ifNA}{Logical, value to return if the result of evaluating \code{x} is \code{NA}. Note that this can be anything (i.e., \code{TRUE}, \code{FALSE}, a number, etc.).}
}
\value{
Logical or value specified in \code{ifNA}.
}
\description{
These functions work exactly the same as \code{x == TRUE} and \code{x == FALSE} but by default return \code{FALSE} for cases that are \code{NA}.
}
\section{Functions}{
\itemize{
\item \code{isFALSENA}: Vectorized test for truth robust to NA
}}

\examples{
x <- c(TRUE, TRUE, FALSE, NA)
x == TRUE
isTRUENA(x)
x == FALSE
isFALSENA(x)
isTRUENA(x, ifNA = Inf)
# note that isTRUE and isFALSE are not vectorized
isTRUE(x)
isFALSE(x)
}
\seealso{
\code{\link{isTRUE}}, \code{\link{isFALSE}}, \code{\link{TRUE}}, \code{\link{logical}}
}
