% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_omx.R
\name{read_all_omx}
\alias{read_all_omx}
\title{Read all matrix cores from an OMX file}
\usage{
read_all_omx(file, names = NULL, long = TRUE)
}
\arguments{
\item{file}{Path to OMX file}

\item{names}{A character vector of matrices to read. If blank, will read all.}

\item{long}{If TRUE (default) will return the matrices as a long tidy 
tibble with the cores as columns. If FALSE will return a list of named
matrices.}
}
\value{
Depending on the value of `long`: if TRUE, a tibble with one core
  per column and one row per interchange; if FALSE, a list of named matrices.
}
\description{
Read all matrix cores from an OMX file
}
\examples{
omxfile <- omxr_example("skims.omx")
read_all_omx(omxfile, names = c("origin", "destination", "DIST", "DISTBIKE", "DISTWALK"))
read_all_omx(omxfile, names = c("DIST", "DISTBIKE", "DISTWALK"), long = FALSE)

  

}
