% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_eamd.R
\name{process_eamd}
\alias{process_eamd}
\title{Process input file and return adherence report}
\usage{
process_eamd(
  infile,
  include_formats = NULL,
  exclude_formats = NULL,
  formats_def = NULL,
  infile_data_output = FALSE,
  regimen = NULL,
  patinfo = NULL,
  nonmonit = NULL,
  med = "",
  adhstart = NULL,
  adhend = NULL
)
}
\arguments{
\item{infile}{Input CSV file name}

\item{include_formats}{Which formats to include in checking}

\item{exclude_formats}{Which formats to exclude from checking}

\item{formats_def}{New formats definition}

\item{infile_data_output}{Include infile data frame in the result}

\item{regimen}{Regimen - regimen definition}

\item{patinfo}{Patient info - patient specific information}

\item{nonmonit}{Non-monitored date intervals}

\item{med}{Medication name}

\item{adhstart}{Report adherence start date}

\item{adhend}{Report adherence end date}
}
\value{
A list containing variables:
\itemize{
  \item \code{report} - Per period adherence statistic
  \item \code{adh} - Summary adherence statistic
}
}
\description{
Process input file and return adherence report
}
\examples{
  input_file <- system.file('extdata', 'sample-data-ecap2.csv', package = 'oncmap')
  report <- process_eamd("tests/testthat/ecap1.csv")
}
