% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.srpmodel}
\alias{plot.srpmodel}
\title{Summary plot of model prior}
\usage{
\method{plot}{srpmodel}(
  x,
  parameter_sample = NULL,
  seed = 42L,
  nsim = 500L,
  warmup = 250,
  nuts_control = list(),
  dt_interval = NULL,
  dt_n_grid = 25,
  dt_expand = 1.1,
  dt_grid = NULL,
  confidence = NULL,
  ...
)
}
\arguments{
\item{x}{the model to plot}

\item{parameter_sample}{a stanfit object with samples from the respective model.}

\item{seed}{integer, fixed random seed; NULL for no fixed seed}

\item{nsim}{integer, number of samples to draw}

\item{warmup}{integer, number of warm-up samples for the MCMC sampler
before retaining samples; see \code{warmup} parameter in \code{\link[rstan:stan]{rstan::stan()}}.}

\item{nuts_control}{list, parameters for NUTS algorithm see \code{control}
argument in\code{\link[rstan:stan]{rstan::stan()}}}

\item{dt_interval}{numeric vector of length two with minimal and maximal
time (relative to individual first visit) to use for plotting}

\item{dt_n_grid}{number of grid points to use when automatically choosing
plotting interval}

\item{dt_expand}{expansion factor for upper plotting limit when using
automatic interval detection}

\item{dt_grid}{numeric vector of time points to use for plotting}

\item{confidence}{numeric in (0, 1) confidence level for point-wise
confidence bands around mean; none plotted if NULL.}

\item{...}{further arguments passed to method implementations}
}
\value{
A \code{patchwork} object, see \link[patchwork:patchwork-package]{patchwork::patchwork}
}
\description{
Summary plot of model prior
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
plot(mdl)

}
\seealso{
\code{\link[=plot_pfs]{plot_pfs()}} \code{\link[=plot_transition_times]{plot_transition_times()}}
\code{\link[=plot_response_probability]{plot_response_probability()}}
}
