% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeXZy.R
\name{makeXZy}
\alias{makeXZy}
\title{Prepare Design Matrices and Response Vector}
\usage{
makeXZy(formula, df)
}
\arguments{
\item{formula}{A symbolic description of the model, where the left-hand side specifies
the response variable and the right-hand side specifies predictors.
Formulas can include a \code{|} operator to separate predictors for different components of a model.}

\item{df}{A data frame containing the variables specified in the formula.}
}
\value{
A list containing the following components:
\describe{
\item{\code{X}}{A design matrix for the main predictors.}
\item{\code{Z}}{A design matrix for additional predictors (e.g., for a secondary process in
a two-component model).}
\item{\code{y}}{The response vector extracted from the formula.}
}
}
\description{
Processes a model formula and a data frame to generate design matrices (\code{X} and \code{Z})
and a response vector (\code{y}) for regression models, including support for complex
formulas with \code{|} operators.
}
\details{
This function processes the formula to extract and construct:
\itemize{
\item \code{X}: The main design matrix.
\item \code{Z}: A secondary design matrix (if a \code{|} operator is used in the formula, separating components).
\item \code{y}: The response variable.
}

It handles cases where the formula specifies:
\itemize{
\item Only the main component (e.g., \code{y ~ x1 + x2}).
\item A secondary component using the \code{|} operator (e.g., \code{y ~ x1 + x2 | z1 + z2}).
}
}
\seealso{
\code{\link{model.matrix}}, \code{\link{model.frame}}, \code{\link{model.response}}
}
\keyword{internal}
