% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_segregation.R
\name{plot.onemap_segreg_test}
\alias{plot.onemap_segreg_test}
\title{Plot p-values for chi-square tests of expected segregation}
\usage{
\method{plot}{onemap_segreg_test}(x, order = TRUE, ...)
}
\arguments{
\item{x}{an object of class onemap_segreg_test (produced by onemap's function
test_segregation()), i. e., after performing segregation tests}

\item{order}{a variable to define if p-values will be ordered in the plot}

\item{...}{currently ignored}
}
\value{
a ggplot graphic
}
\description{
Draw a graphic showing the p-values (re-scaled to -log10(p-values)) associated with the
chi-square tests for the expected segregation patterns for all markers in a dataset.
It includes a vertical line showing the threshold for declaring statistical significance
if Bonferroni's correction is considered, as well as the percentage of markers that
will be discarded if this criterion is used.
}
\examples{

data(onemap_example_bc) # load OneMap's fake dataset for a backcross population
BC.seg <- test_segregation(onemap_example_bc) # Applies chi-square tests
print(BC.seg) # Shows the results
plot(BC.seg) # Plot the graph, ordering the p-values
plot(BC.seg, order=FALSE) # Plot the graph showing the results keeping the order in the dataset
# You can store the graphic in an object, then save it.
# For details, see the help of ggplot2's function ggsave()
# g <- plot(BC.seg)
# ggplot2::ggsave("SegregationTests.jpg", g, width=7, height=5, dpi=600)

data(onemap_example_out) # load OneMap's fake dataset for an outcrossing population
Out.seg <- test_segregation(onemap_example_out) # Applies chi-square tests
print(Out.seg) # Shows the results
plot(Out.seg) # Plot the graph, ordering the p-values
plot(Out.seg, order=FALSE) # Plot the graph showing the results keeping the order in the dataset
# You can store the graphic in an object, then save it.
# For details, see the help of ggplot2's function ggsave()
g <- plot(Out.seg)
# ggplot2::ggsave("SegregationTests.jpg", g, width=7, height=5, dpi=600)
}
