% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_graph_table.R
\name{rf_graph_table}
\alias{rf_graph_table}
\title{Plots pairwise recombination fractions and LOD Scores in a heatmap}
\usage{
rf_graph_table(
  input.seq,
  graph.LOD = FALSE,
  main = NULL,
  inter = FALSE,
  html.file = NULL,
  mrk.axis = "numbers",
  lab.xy = NULL,
  n.colors = 4,
  display = TRUE
)
}
\arguments{
\item{input.seq}{an object of class \code{sequence} with a predefined
order.}

\item{graph.LOD}{logical. If \code{TRUE}, displays the LOD heatmap, otherwise,
displays the recombination fraction heatmap.}

\item{main}{character. The title of the plot.}

\item{inter}{logical. If \code{TRUE}, an interactive HTML graphic is plotted.
Otherwise, a default graphic device is used.}

\item{html.file}{character naming the html file with iterative graphic.}

\item{mrk.axis}{character, "names" to display marker names in the axis, "numbers" to display
marker numbers and "none" to display axis free of labels.}

\item{lab.xy}{character vector with length 2, first component is the label of x axis and second of the y axis.}

\item{n.colors}{integer. Number of colors in the pallete.}

\item{display}{logical. If inter \code{TRUE} and display \code{TRUE} iteractive graphic is plotted in browser automatically when run the function}
}
\value{
a ggplot graphic
}
\description{
Plots a matrix of pairwise recombination fraction or
LOD Scores using a color scale. Any value of the
matrix can be easily accessed using an interactive plotly-html interface,
helping users to check for possible problems.
}
\details{
The color scale varies from red (small distances or big LODs) to purple.
When hover on a cell, a dialog box is displayed with some information
about corresponding markers for that cell (line (y) \eqn{\times} column (x)). They are:
\eqn{i}) the name of the markers; \eqn{ii}) the number of
the markers on the data set; \eqn{iii}) the segregation types; \eqn{iv})
the recombination fraction between the markers and \eqn{v}) the LOD-Score
for each possible linkage phase calculated via two-point analysis. For
neighbor markers, the multipoint recombination fraction is printed;
otherwise, the two-point recombination fraction is printed. For markers of
type \code{D1} and \code{D2}, it is impossible to calculate recombination
fraction via two-point analysis and, therefore, the corresponding cell will
be empty (white color). For cells on the diagonal of the matrix, the name, the number and
the type of the marker are printed, as well as the percentage of missing
data for that marker.
}
\examples{

\donttest{
##outcross example
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.rcd <- rcd(LG1)
  rf_graph_table(LG1.rcd, inter=FALSE)


  ##F2 example
  data(onemap_example_f2)
  twopt <- rf_2pts(onemap_example_f2)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)

  ##"pre-allocate" an empty list of length groups$n.groups (3, in this case)
  maps.list<-vector("list", groups$n.groups)

  for(i in 1:groups$n.groups){
    ##create linkage group i
    LG.cur <- make_seq(groups,i)
    ##ordering
    map.cur<-order_seq(LG.cur, subset.search = "sample")
    ##assign the map of the i-th group to the maps.list
    maps.list[[i]]<-make_seq(map.cur, "force")
  }
}
}
\author{
Rodrigo Amadeu, \email{rramadeu@gmail.com}
}
\keyword{utilities}
