% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{remove_uninformative_terms}
\alias{remove_uninformative_terms}
\title{Retain only the most specific terms which are present in each unique set of term sets}
\usage{
remove_uninformative_terms(ontology, term_sets)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}
}
\value{
Character vector of terms
}
\description{
Useful in finding a relatively small set of terms which captures the structure and overlap of terms within a set of term sets.
}
\examples{
library(ontologyIndex)
data(hpo)
remove_uninformative_terms(hpo, list(Patient1=c("HP:0001873")))
}

