% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{edgeplot}
\alias{edgeplot}
\title{Plot edge profiles and contMap}
\usage{
edgeplot(map_stat, prof_stat, plot.cont = TRUE)
}
\arguments{
\item{map_stat}{contMap object. A contMap obtained using the 'make_contMap_KDE' function.}

\item{prof_stat}{tibble. A tibble with the edgeplot information obtained using the 'edge_profiles4plotting' function.}

\item{plot.cont}{logical. Whether to plot also the contMap or not.}
}
\value{
A plot with the edge profiles and contMap of the selected statistic (e.g. branch rates).
}
\description{
Wrapper function for plotting edge profiles and contmap from NHPP.
}
\examples{
data("hym_tree", "hym_kde")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get smoothing of normalized edge KDE data for mean rates.
Edge_KDE <- hym_kde$head
Edge_KDE_stat <- Edge_KDE$loess.lambda.mean
# Make contmap nhpp data.
map_stat <- make_contMap_KDE(tree_discr, Edge_KDE_stat)
# Make edgeplot nhpp data.
prof_stat <- edge_profiles4plotting(tree_discr, Edge_KDE_stat)
# Plot.
suppressWarnings(edgeplot(map_stat, prof_stat))

}
\author{
Diego Porto
}
