/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.util.SequenceValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserChunkerSequenceValidator
implements SequenceValidator<String> {
    private Map<String, String> continueStartMap;

    public ParserChunkerSequenceValidator(ChunkerModel model) {
        this.continueStartMap = new HashMap<String, String>(model.getChunkerModel().getNumOutcomes());
        int on = model.getChunkerModel().getNumOutcomes();
        for (int oi = 0; oi < on; ++oi) {
            String outcome = model.getChunkerModel().getOutcome(oi);
            if (!outcome.startsWith("C-")) continue;
            this.continueStartMap.put(outcome, "S-" + outcome.substring("C-".length()));
        }
    }

    public boolean validSequence(int i, String[] inputSequence, String[] tagList, String outcome) {
        if (this.continueStartMap.containsKey(outcome)) {
            int lti = tagList.length - 1;
            if (lti == -1) {
                return false;
            }
            String lastTag = tagList[lti];
            if (lastTag.equals(outcome)) {
                return true;
            }
            if (lastTag.equals(this.continueStartMap.get(outcome))) {
                return true;
            }
            if (lastTag.equals("O")) {
                return false;
            }
            return false;
        }
        return true;
    }
}

