% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_fine_tunes.R
\name{list_fine_tunes}
\alias{list_fine_tunes}
\title{Lists fine-tunes}
\usage{
list_fine_tunes(
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which is a data frame containing
information about fine-tunes.
}
\description{
Lists organization's fine-tuning jobs. See \href{https://beta.openai.com/docs/api-reference/fine-tunes/list}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/fine-tunes/list}{official documentation}.
}
\examples{
\dontrun{
list_fine_tunes()
}
}
\seealso{
Other fine-tune functions: 
\code{\link{cancel_fine_tune}()},
\code{\link{create_fine_tune}()},
\code{\link{delete_fine_tune_model}()},
\code{\link{list_fine_tune_events}()},
\code{\link{retrieve_fine_tune}()}
}
\concept{fine-tune functions}
