% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_image.R
\name{create_image}
\alias{create_image}
\title{Create image}
\usage{
create_image(
  prompt,
  n = 1,
  size = c("1024x1024", "256x256", "512x512"),
  response_format = c("url", "b64_json"),
  user = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{prompt}{required; a length one character vector.}

\item{n}{required; defaults to \code{1}; a length one numeric vector with the
integer value greater than \code{0}.}

\item{size}{required; defaults to \code{"1024x1024"}; a length one character
vector, one among \code{"256x256"}, \code{"512x512"}, and \code{"1024x1024"}.}

\item{response_format}{required; defaults to \code{"url"}; a length one character
vector, one among \code{"url"} and \code{"b64_json"}.}

\item{user}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which contain either a link to the
generated image or the generated image decoded in Base64.
}
\description{
Creates an image given a prompt. See \href{https://platform.openai.com/docs/api-reference/images/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/images/create}{official documentation}.
}
\examples{
\dontrun{
create_image("An astronaut riding a horse in a photorealistic style")
}
}
\seealso{
Other image functions: 
\code{\link{create_image_edit}()},
\code{\link{create_image_variation}()}
}
\concept{image functions}
