% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentileMap.R
\name{percentileMap}
\alias{percentileMap}
\title{Percentile roses on interactive leaflet maps}
\usage{
percentileMap(
  data,
  pollutant = NULL,
  percentile = c(25, 50, 75, 90, 95),
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "jet",
  key = FALSE,
  draw.legend = TRUE,
  collapse.control = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 3.5,
  fig.height = 3.5,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{percentile}{The percentile value(s) to plot. Must be between 0–100. If
\code{percentile = NA} then only a mean line will be shown.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
\dQuote{lat}/\dQuote{latitude} or
\dQuote{lon}/\dQuote{lng}/\dQuote{long}/\dQuote{longitude}
(case-insensitively).}

\item{control}{Column to be used for splitting the input data into different
groups which can be selected between using a "layer control" interface.
Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}. \code{control} cannot be used if multiple
\code{pollutant} columns have been provided.}

\item{popup}{Column to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.).}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting.}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{draw.legend}{Should a shared legend be created at the side of the map?
Default is \code{TRUE}.}

\item{collapse.control}{Should the "layer control" interface be collapsed?
Defaults to \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{type}{Deprecated. Please use \code{label} and/or \code{popup} to label
different sites.}

\item{...}{
  Arguments passed on to \code{\link[openair:percentileRose]{openair::percentileRose}}
  \describe{
    \item{\code{wd}}{Name of the wind direction field.}
    \item{\code{smooth}}{Should the wind direction data be smoothed using a
cyclic spline?}
    \item{\code{method}}{When \code{method = "default"} the supplied
percentiles by wind direction are calculated. When \code{method
= "cpf"} the conditional probability function (CPF) is plotted
and a single (usually high) percentile level is supplied. The
CPF is defined as CPF = my/ny, where my is the number of samples
in the wind sector y with mixing ratios greater than the
\emph{overall} percentile concentration, and ny is the total
number of samples in the same wind sector (see Ashbaugh et al.,
1985).}
    \item{\code{angle}}{Default angle of \dQuote{spokes} is when \code{smooth = FALSE}.}
    \item{\code{mean}}{Show the mean by wind direction as a line?}
    \item{\code{mean.lty}}{Line type for mean line.}
    \item{\code{mean.lwd}}{Line width for mean line.}
    \item{\code{mean.col}}{Line colour for mean line.}
    \item{\code{fill}}{Should the percentile intervals be filled (default) or
should lines be drawn (\code{fill = FALSE}).}
    \item{\code{intervals}}{User-supplied intervals for the scale e.g.
\code{intervals = c(0, 10, 30, 50)}}
    \item{\code{angle.scale}}{The pollutant scale is by default shown at a 45
degree angle. Sometimes the placement of the scale may interfere
with an interesting feature. The user can therefore set
\code{angle.scale} to another value (between 0 and 360 degrees)
to mitigate such problems. For example \code{angle.scale = 315}
will draw the scale heading in a NW direction.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If
\code{TRUE} titles and axis labels will automatically try and
format pollutant names and units properly e.g.  by subscripting
the \sQuote{2} in NO2.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key.
For example, passing options \code{key.header = "header",
key.footer = "footer"} adds addition text above and below the
scale key. These arguments are passed to \code{drawOpenKey} via
\code{quickText}, applying the \code{auto.text} argument, to
handle formatting.}
    \item{\code{key.footer}}{\code{key.header}.}
    \item{\code{key.position}}{Location where the scale key is to plotted.
Allowed arguments currently include \code{"top"},
\code{"right"}, \code{"bottom"} and \code{"left"}.}
  }}
}
\value{
A leaflet object.
}
\description{
\code{\link[=percentileMap]{percentileMap()}} creates a \code{leaflet} map using percentile roses as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be added and toggled between
using \code{control}. See \code{\link[openair:percentileRose]{openair::percentileRose()}} for more information.
}
\examples{
\dontrun{
percentileMap(polar_data,
  pollutant = "nox",
  provider = "Stamen.Toner"
)
}
}
\seealso{
Other directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{freqMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()},
\code{\link{windroseMap}()}
}
\concept{directional analysis maps}
