% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_odf.R
\name{write_odf}
\alias{write_odf}
\title{Write R data frame to the Open Data Format.}
\usage{
write_odf(
  x,
  file,
  languages = "all",
  export_data = TRUE,
  verbose = TRUE,
  compression_level = 5,
  odf_version = "1.1.0"
)
}
\arguments{
\item{x}{R data frame (df) to be writtem.}

\item{file}{Path to ZIP file or name of zip file to save the odf-dataset
in the working directory.}

\item{languages}{Select the language in which the descriptions and labels of the data will be
exported
\itemize{
\item By default all available language variants are exported
(\code{languages = "all"}).
\item You can also choose to export only the default language
(\code{languages = "default"}),
\item Or only the current language
(\code{languages = "current"}),
\item or you can select the language by language code, e.g.
\code{languages = "en"}.
}}

\item{export_data}{Choose, if you want to export the file that holds the
data (data.csv).Default is TRUE.}

\item{verbose}{Display more messages.}

\item{compression_level}{A number between 1 and 9. 9 compresses best, but it also takes the longest.}

\item{odf_version}{The ODF version of the output file. Default is the actual/most recent version.
\itemize{
\item By default the data and metadata are exported (\code{export_data = TRUE}).
\item To export only metadata and no data, select \code{export_data = FALSE}
}}
}
\value{
ZIP file and unzipped directory containing the data as CSV file and
the metadata as XML file (DDI Codebook 2.5.).
}
\description{
Export data from an R data frame to a ZIP file that stores
the data as Open Data Format.
}
\examples{
# get example data from the opendataformat package
df  <-  get(data("data_odf"))

# write R data frame with attributes to the file my_data.zip specified
# as Open Data Format.
write_odf(x = df, paste0(tempdir(), "/my_data.zip"))

# write R data frame with attributes to the file my_data.zip
# with selected language.
write_odf(x = df,  paste0(tempdir(), "/my_data.zip"), languages = "en")

# write R data frame with attributes to the file my_data.zip but only
# metadata, no data.
write_odf(x = df,  file = paste0(tempdir(), "/my_data.zip"), export_data = FALSE)


}
