% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ModelExtras.R
\name{get_model_lang_list}
\alias{get_model_lang_list}
\alias{get_model_word_list}
\alias{get_model_profile}
\alias{get_model_profile_list}
\title{Model Extras}
\usage{
get_model_lang_list(model)

get_model_word_list(model)

get_model_profile(model, profile)

get_model_profile_list(model)
}
\arguments{
\item{model}{Model digest or model name.}

\item{profile}{Profile name.}
}
\value{
A \code{list} from a JSON response object.
}
\description{
Functions for retrieving extra model information, including language lists,
word lists, profiles, and profile lists. More information about these API
endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#get-model-extras}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_model_lang_list('RiskPaths')
}

}
