% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-connect.R
\name{otp_connect}
\alias{otp_connect}
\title{Set up and confirm a connection to an OTP instance.}
\usage{
otp_connect(
  hostname = "localhost",
  router = "default",
  url = NULL,
  port = 8080,
  ssl = FALSE,
  check = TRUE,
  timezone = Sys.timezone()
)
}
\arguments{
\item{hostname}{A string, e.g. "ec2-34-217-73-26.us-west-2.compute.amazonaws.com".
Optional, default is "localhost".}

\item{router}{A string, e.g. "UK2018". Optional, default is "default". OTP can support multiple routers see advanced vignette for details.}

\item{url}{If a non-standard URL structure is used provide a full url,
default is NULL}

\item{port}{A positive integer. Optional, default is 8080.}

\item{ssl}{Logical, indicates whether to use https. Optional,
default is FALSE.}

\item{check}{Logical. If TRUE connection object is only returned if OTP
instance and router are confirmed reachable. Optional, default is TRUE.}

\item{timezone}{Character, timezone, defaults to local timezone}
}
\value{
Returns an S3 object of class otpconnect. If \code{check} is TRUE
    and the router is not reachable the object is not returned.
}
\description{
Defines the parameters required to connect to a router on an OTP
instance and, if required, confirms that the instance and router
are query-able.
}
\details{
The default URL structure for the OTP API is:
http://<hostname>:<port>/otp/routers/<router>
For example: http://localhost:8080/otp/routers/default

Functions construct the URL from the parameters provided in otpconnect
objects. However some websites hosting OTP have modified the default
URL structure. If this is the case you can use the \code{url} parameter
to bypass the URL construction and provide a fully formed URL. In this
case the \code{hostname}, \code{router}, \code{port}, and \code{ssl}
are ignored.
}
\examples{
\dontrun{
otpcon <- otp_connect()
otpcon <- otp_connect(
  router = "UK2018",
  ssl = TRUE
)
otpcon <- otp_connect(
  hostname = "ec2.us-west-2.compute.amazonaws.com",
  router = "UK2018",
  port = 8888,
  ssl = TRUE
)
otpcon <- otp_connect(
  url = "https://api.digitransit.fi:443/routing/v1/routers/hsl"
)
}
}
\concept{connect}
