% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-surface.R
\name{otp_make_surface}
\alias{otp_make_surface}
\title{Make a Surface}
\usage{
otp_make_surface(
  otpcon = NULL,
  fromPlace = c(-1.17502, 50.6459),
  mode = "CAR",
  date_time = Sys.time(),
  maxWalkDistance = 1000,
  arriveBy = FALSE,
  routeOptions = NULL,
  timezone = otpcon$timezone
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{fromPlace}{Numeric vector, Longitude/Latitude pair, e.g.
`c(-0.134649,51.529258)`, or 2 column matrix of Longitude/Latitude pairs,
or sf data frame of POINTS with CRS 4326}

\item{mode}{character vector of one or more modes of travel valid values
TRANSIT, WALK, BICYCLE, CAR, BUS, RAIL, SUBWAY, TRAM, FERRY, default CAR.
Not all combinations are valid e.g. c("WALK","BUS") is valid but
c("WALK","CAR") is not.}

\item{date_time}{POSIXct, a date and time, defaults to current date and time}

\item{maxWalkDistance}{Numeric passed to OTP in metres}

\item{arriveBy}{Logical, Whether the trip should depart or arrive at the
specified date and time, default FALSE}

\item{routeOptions}{Named list of values passed to OTP use}

\item{timezone}{Character, what timezone to use, see as.POSIXct, default is
local timezone}
}
\value{
Returns a list with information about the surface created
}
\description{
Requires OTP 1.x and the analyst
}
\details{
THis function requires the analysis and pointset features to be
  enabled during `otp_setup()`. Thus it will only work with OTP 1.x. For more
  detail see the analyst vignette.
}
\examples{
\dontrun{
surface <- otp_make_surface(otpcon, c(-1.17502, 50.64590))
}
}
\seealso{
Other analyst: 
\code{\link{otp_traveltime}()}
}
\concept{analyst}
