% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-traveltime.R
\name{otp_traveltime}
\alias{otp_traveltime}
\title{Get travel times between points}
\usage{
otp_traveltime(
  otpcon = NA,
  path_data = NULL,
  fromPlace = NA,
  toPlace = NA,
  fromID = NULL,
  toID = NULL,
  mode = "CAR",
  date_time = Sys.time(),
  arriveBy = FALSE,
  maxWalkDistance = 1000,
  numItineraries = 3,
  routeOptions = NULL,
  ncores = 1,
  timezone = otpcon$timezone
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{path_data}{Path to data used in otp_build_graph()}

\item{fromPlace}{Numeric vector, Longitude/Latitude pair, e.g.
`c(-0.134649,51.529258)`, or 2 column matrix of Longitude/Latitude pairs,
or sf data frame of POINTS with CRS 4326}

\item{toPlace}{Numeric vector, Longitude/Latitude pair, e.g.
`c(-0.088780,51.506383)`, or 2 column matrix of Longitude/Latitude pairs,
or sf data frame of POINTS with CRS 4326}

\item{fromID}{character vector same length as fromPlace}

\item{toID}{character vector same length as toPlace}

\item{mode}{character vector of one or more modes of travel valid values
TRANSIT, WALK, BICYCLE, CAR, BUS, RAIL, default CAR. Not all combinations
are valid e.g. c("WALK","BUS") is valid but c("WALK","CAR") is not.}

\item{date_time}{POSIXct, a date and time, defaults to current date and time}

\item{arriveBy}{Logical, Whether the trip should depart or arrive at the
specified date and time, default FALSE}

\item{maxWalkDistance}{Numeric passed to OTP in metres}

\item{numItineraries}{The maximum number of possible itineraries to return}

\item{routeOptions}{Named list of values passed to OTP use
`otp_route_options()` to make template object.}

\item{ncores}{Numeric, number of cores to use when batch processing, default
1, see details}

\item{timezone}{Character, what timezone to use, see as.POSIXct, default is
local timezone}
}
\value{
Returns an  data frame
}
\description{
This function requires OTP 1.x and the analyst
}
\details{
Make a travel time matrix using the analyst features in OPT 1.x
}
\seealso{
Other analyst: 
\code{\link{otp_make_surface}()}
}
\concept{analyst}
