% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openXL.R
\name{openXL}
\alias{openXL}
\title{Open a Microsoft Excel file (xls/xlsx) or an openxlsx Workbook}
\usage{
openXL(file=NULL)
}
\arguments{
\item{file}{path to the Excel (xls/xlsx) file or Workbook object.}
}
\description{
This function tries to open a Microsoft Excel
(xls/xlsx) file or an openxlsx Workbook with the proper
application, in a portable manner.

In Windows (c) and Mac (c), it uses system default handlers,
given the file type.

In Linux it searches (via \code{which}) for available xls/xlsx
reader applications (unless \code{options('openxlsx.excelApp')}
is set to the app bin path), and if it finds anything, sets
\code{options('openxlsx.excelApp')} to the program choosed by
the user via a menu (if many are present, otherwise it will
set the only available). Currently searched for apps are
Libreoffice/Openoffice (\code{soffice} bin), Gnumeric
(\code{gnumeric}) and Calligra Sheets (\code{calligrasheets}).
}
\examples{
# file example
example(writeData)
#openXL("writeDataExample.xlsx")

# (not yet saved) Workbook example
wb <- createWorkbook()
x <- mtcars[1:6,]
addWorksheet(wb, "Cars")
writeData(wb, "Cars", x, startCol = 2, startRow = 3, rowNames = TRUE)
#openXL(wb)

}
\author{
Luca Braglia
}
