% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{convert_datetime}
\alias{convert_datetime}
\title{Convert from excel time number to R POSIXct type.}
\usage{
convert_datetime(x, origin = "1900-01-01", ...)
}
\arguments{
\item{x}{A numeric vector}

\item{origin}{date. Default value is for Windows Excel 2010}

\item{...}{Additional parameters passed to as.POSIXct}
}
\description{
Convert from excel time number to R POSIXct type.
}
\details{
Excel stores dates as number of days from some origin date
}
\examples{
## 2014-07-01, 2014-06-30, 2014-06-29
x <- c(41821.8127314815, 41820.8127314815, NA, 41819, NaN)
convert_datetime(x)
convert_datetime(x, tz = "Australia/Perth")
convert_datetime(x, tz = "UTC")
}
