% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_font}
\alias{wb_add_font}
\title{add font for cell region}
\usage{
wb_add_font(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name = "Calibri",
  color = wb_colour(hex = "FF000000"),
  size = "11",
  bold = "",
  italic = "",
  outline = "",
  strike = "",
  underline = "",
  charset = "",
  condense = "",
  extend = "",
  family = "",
  scheme = "",
  shadow = "",
  vertAlign = ""
)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{name}{font name: default "Calibri"}

\item{color}{rgb color: default "FF000000"}

\item{size}{font size: default "11",}

\item{bold}{bold, "single" or "double", default: ""}

\item{italic}{italic}

\item{outline}{outline}

\item{strike}{strike}

\item{underline}{underline}

\item{charset}{charset}

\item{condense}{condense}

\item{extend}{extend}

\item{family}{font family}

\item{scheme}{font scheme}

\item{shadow}{shadow}

\item{vertAlign}{vertical alignment}
}
\value{
The \code{wbWorksheetObject}, invisibly
}
\description{
add font for cell region
}
\details{
add_font provides all the options openxml accepts for a font node, not all have to be set. Usually name, size and color should be what the user wants.
}
\examples{
 wb <- wb_workbook() \%>\% wb_add_worksheet("S1") \%>\% wb_add_data("S1", mtcars)
 wb \%>\% wb_add_font("S1", "A1:K1", name = "Arial", color = wb_colour(theme = "4"))
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_clone_sheet_style}()}
}
\concept{styles}
