% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_load.R
\name{wb_load}
\alias{wb_load}
\title{Load an existing .xlsx file}
\usage{
wb_load(file, xlsxFile = NULL, sheet, data_only = FALSE)
}
\arguments{
\item{file}{A path to an existing .xlsx or .xlsm file}

\item{xlsxFile}{alias for file}

\item{sheet}{optional sheet parameter. if this is applied, only the selected
sheet will be loaded.}

\item{data_only}{mode to import if only a data frame should be returned. This
strips the wbWorkbook to a bare minimum.}
}
\value{
Workbook object.
}
\description{
wb_load returns a workbook object conserving styles and
formatting of the original .xlsx file.
}
\details{
A warning is displayed if an xml namespace for main is found in the
xlsx file. Certain xlsx files created by third-party applications contain a
namespace (usually \code{x}). This namespace is not required for the file to work
in spreadsheet software and is not expected by \code{openxlsx2}. Therefore it is
removed when the file is loaded into a workbook. Removal is generally
expected to be safe, but the feature is still experimental.
}
\examples{
## load existing workbook from package folder
wb <- wb_load(file = system.file("extdata", "loadExample.xlsx", package = "openxlsx2"))
wb$get_sheet_names() # list worksheets
wb ## view object
## Add a worksheet
wb$add_worksheet("A new worksheet")
}
\seealso{
\code{\link[=wb_remove_worksheet]{wb_remove_worksheet()}}
}
