% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-comment.R, R/class-workbook-wrappers.R
\name{create_comment}
\alias{create_comment}
\alias{wb_add_comment}
\alias{wb_remove_comment}
\title{Create, write and remove comments}
\usage{
create_comment(
  text,
  author = Sys.info()[["user"]],
  style = NULL,
  visible = TRUE,
  width = 2,
  height = 4
)

wb_add_comment(wb, sheet = current_sheet(), dims = "A1", comment, ...)

wb_remove_comment(wb, sheet = current_sheet(), dims = "A1", ...)
}
\arguments{
\item{text}{Comment text. Character vector.}

\item{author}{Author of comment. A string.}

\item{style}{A Style object or list of style objects the same length as comment vector.}

\item{visible}{\code{TRUE} or \code{FALSE}. Is comment visible?}

\item{width}{Textbox integer width in number of cells}

\item{height}{Textbox integer height in number of cells}

\item{wb}{A workbook object}

\item{sheet}{A worksheet of the workbook}

\item{dims}{Optional row and column as spreadsheet dimension, e.g. "A1"}

\item{comment}{A comment to apply to the worksheet}

\item{...}{additional arguments}
}
\value{
The \code{wbWorkbook} object
}
\description{
The comment functions (create, write and remove) allow the
modification of comments. In newer spreadsheet software they are called
notes, while they are called comments in openxml. Modification of what
newer spreadsheet software now calls comment is possible via
\code{\link[=wb_add_thread]{wb_add_thread()}}.
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

# write comment without author
c1 <- create_comment(text = "this is a comment", author = "")
wb$add_comment(dims = "B10", comment = c1)

# Write another comment with author information
c2 <- create_comment(text = "this is another comment", author = "Marco Polo")
wb$add_comment(sheet = 1, dims = "C10", comment = c2)

# write a styled comment with system author
s1 <- create_font(b = "true", color = wb_color(hex = "FFFF0000"), sz = "12")
s2 <- create_font(color = wb_color(hex = "FF000000"), sz = "9")
c3 <- create_comment(text = c("This Part Bold red\n\n", "This part black"), style = c(s1, s2))

wb$add_comment(sheet = 1, dims = wb_dims(3, 6), comment = c3)

# remove the first comment c1
wb$remove_comment(1, dims = "B10")
}
\seealso{
\code{\link[=wb_add_thread]{wb_add_thread()}}
}
