% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl_open.R
\name{xl_open}
\alias{xl_open}
\alias{xl_open.wbWorkbook}
\alias{xl_open.default}
\title{Open an xlsx file or a \code{wbWorkbook} object}
\usage{
xl_open(x, interactive = NA)

\method{xl_open}{wbWorkbook}(x, interactive = NA)

\method{xl_open}{default}(x, interactive = NA)
}
\arguments{
\item{x}{A path to the Excel (xls/xlsx) file or wbWorkbook object.}

\item{interactive}{If \code{FALSE} will throw a warning and not open the path.
This can be manually set to \code{TRUE}, otherwise when \code{NA} (default) uses the
value returned from \code{\link[base:interactive]{base::interactive()}}}
}
\description{
This function tries to open a Microsoft Excel (xls/xlsx) file or,
an \link{wbWorkbook} with the proper application, in a portable manner.

On Windows it uses \code{base::shell.exec()} (Windows only function) to
determine the appropriate program.

On Mac, (c) it uses system default handlers, given the file type.

On Linux, it searches (via \code{which}) for available xls/xlsx reader
applications (unless \code{options('openxlsx2.excelApp')} is set to the app bin
path), and if it finds anything, sets \code{options('openxlsx2.excelApp')} to the
program chosen by the user via a menu (if many are present, otherwise it
will set the only available). Currently searched for apps are
Libreoffice/Openoffice (\code{soffice} bin), Gnumeric (\code{gnumeric}) and Calligra
Sheets (\code{calligrasheets}).
}
\examples{
\donttest{
if (interactive()) {
  xlsx_file <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
  xl_open(xlsx_file)

  # (not yet saved) Workbook example
  wb <- wb_workbook()
  x <- mtcars[1:6, ]
  wb$add_worksheet("Cars")
  wb$add_data("Cars", x, start_col = 2, start_row = 3, row_names = TRUE)
  xl_open(wb)
}
}
}
