% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_formula}
\alias{wb_add_formula}
\title{Add a formula to a cell range in a worksheet}
\usage{
wb_add_formula(
  wb,
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  cm = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  enforce = FALSE,
  shared = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. (either as index or name)}

\item{x}{A formula as character vector.}

\item{dims}{Spreadsheet dimensions that will determine where \code{x} spans: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write to.}

\item{start_row}{A vector specifying the starting row to write to.}

\item{array}{A bool if the function written is of type array}

\item{cm}{A special kind of array function that hides the curly braces in the cell.
Add this, if you see "@" inserted into your formulas.}

\item{apply_cell_style}{Should we write cell styles to the workbook?}

\item{remove_cell_style}{Should we keep the cell style?}

\item{enforce}{enforce dims}

\item{shared}{shared formula}

\item{...}{additional arguments}
}
\value{
The workbook, invisibly.
}
\description{
This function can be used to add a formula to a worksheet.
In \code{wb_add_formula()}, you can provide the formula as a character vector.
}
\details{
Currently, the local translations of formulas are not supported.
Only the English functions work.

The examples below show a small list of possible formulas:
\itemize{
\item SUM(B2:B4)
\item AVERAGE(B2:B4)
\item MIN(B2:B4)
\item MAX(B2:B4)
\item ...
}

It is possible to pass vectors to \code{x}. If \code{x} is an array formula, it will
take \code{dims} as a reference. For some formulas, the result will span multiple
cells (see the \code{MMULT()} example below). For this type of formula, the
output range must be known a priori and passed to \code{dims}, otherwise only the
value of the first cell will be returned. This type of formula, whose result
extends over several cells, is only possible with single strings. If a vector
is passed, it is only possible to return individual cells.
}
\examples{
wb <- wb_workbook()$add_worksheet()
wb$add_data(dims = wb_dims(rows = 1, cols = 1:3), x = c(4, 5, 8))

# calculate the sum of elements.
wb$add_formula(dims = "D1", x = "SUM(A1:C1)")

# array formula with result spanning over multiple cells
mm <- matrix(1:4, 2, 2)

wb$add_worksheet()$
 add_data(x = mm, dims = "A1:B2", col_names = FALSE)$
 add_data(x = mm, dims = "A4:B5", col_names = FALSE)$
 add_formula(x = "MMULT(A1:B2, A4:B5)", dims = "A7:B8", array = TRUE)

# add shared formula
wb$add_worksheet()$
 add_data(x = matrix(rnorm(5*5), ncol = 5, nrow = 5))$
 add_formula(x = "SUM($A2:A2)", dims = "A8:E12", shared = TRUE)

}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
