% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{wb_to_df}
\alias{wb_to_df}
\alias{read_xlsx}
\alias{wb_read}
\title{Create a data frame from a Workbook}
\usage{
wb_to_df(
  file,
  sheet,
  start_row = 1,
  start_col = NULL,
  row_names = FALSE,
  col_names = TRUE,
  skip_empty_rows = FALSE,
  skip_empty_cols = FALSE,
  skip_hidden_rows = FALSE,
  skip_hidden_cols = FALSE,
  rows = NULL,
  cols = NULL,
  detect_dates = TRUE,
  na.strings = "#N/A",
  na.numbers = NA,
  fill_merged_cells = FALSE,
  dims,
  show_formula = FALSE,
  convert = TRUE,
  types,
  named_region,
  keep_attributes = FALSE,
  check_names = FALSE,
  ...
)

read_xlsx(
  file,
  sheet,
  start_row = 1,
  start_col = NULL,
  row_names = FALSE,
  col_names = TRUE,
  skip_empty_rows = FALSE,
  skip_empty_cols = FALSE,
  rows = NULL,
  cols = NULL,
  detect_dates = TRUE,
  named_region,
  na.strings = "#N/A",
  na.numbers = NA,
  fill_merged_cells = FALSE,
  check_names = FALSE,
  ...
)

wb_read(
  file,
  sheet = 1,
  start_row = 1,
  start_col = NULL,
  row_names = FALSE,
  col_names = TRUE,
  skip_empty_rows = FALSE,
  skip_empty_cols = FALSE,
  rows = NULL,
  cols = NULL,
  detect_dates = TRUE,
  named_region,
  na.strings = "NA",
  na.numbers = NA,
  check_names = FALSE,
  ...
)
}
\arguments{
\item{file}{An xlsx file, \link{wbWorkbook} object or URL to xlsx file.}

\item{sheet}{Either sheet name or index. When missing the first sheet in the workbook is selected.}

\item{start_row}{first row to begin looking for data.}

\item{start_col}{first column to begin looking for data.}

\item{row_names}{If \code{TRUE}, the first col of data will be used as row names.}

\item{col_names}{If \code{TRUE}, the first row of data will be used as column names.}

\item{skip_empty_rows}{If \code{TRUE}, empty rows are skipped.}

\item{skip_empty_cols}{If \code{TRUE}, empty columns are skipped.}

\item{skip_hidden_rows}{If \code{TRUE}, hidden rows are skipped.}

\item{skip_hidden_cols}{If \code{TRUE}, hidden columns are skipped.}

\item{rows}{A numeric vector specifying which rows in the xlsx file to read.
If \code{NULL}, all rows are read.}

\item{cols}{A numeric vector specifying which columns in the xlsx file to read.
If \code{NULL}, all columns are read.}

\item{detect_dates}{If \code{TRUE}, attempt to recognize dates and perform conversion.}

\item{na.strings}{A character vector of strings which are to be interpreted as \code{NA}.
Blank cells will be returned as \code{NA}.}

\item{na.numbers}{A numeric vector of digits which are to be interpreted as \code{NA}.
Blank cells will be returned as \code{NA}.}

\item{fill_merged_cells}{If \code{TRUE}, the value in a merged cell is given to all cells within the merge.}

\item{dims}{Character string of type "A1:B2" as optional dimensions to be imported.}

\item{show_formula}{If \code{TRUE}, the underlying Excel formulas are shown.}

\item{convert}{If \code{TRUE}, a conversion to dates and numerics is attempted.}

\item{types}{A named numeric indicating, the type of the data.
Names must match the returned data. See \strong{Details} for more.}

\item{named_region}{Character string with a \code{named_region} (defined name or table).
If no sheet is selected, the first appearance will be selected. See \code{\link[=wb_get_named_regions]{wb_get_named_regions()}}}

\item{keep_attributes}{If \code{TRUE} additional attributes are returned.
(These are used internally to define a cell type.)}

\item{check_names}{If \code{TRUE} then the names of the variables in the data frame are checked to ensure that they are syntactically valid variable names.}

\item{...}{additional arguments}
}
\description{
Simple function to create a \code{data.frame} from a sheet in workbook. Simple as
in it was simply written down. \code{read_xlsx()} and \code{wb_read()} are just
internal wrappers of \code{wb_to_df()} intended for people coming from other
packages.
}
\details{
The returned data frame will have named rows matching the rows of the
worksheet. With \code{col_names = FALSE} the returned data frame will have
column names matching the columns of the worksheet. Otherwise the first
row is selected as column name.

Depending if the R package \code{hms} is loaded, \code{wb_to_df()} returns
\code{hms} variables or string variables in the \code{hh:mm:ss} format.

The \code{types} argument must be a named numeric.
\itemize{
\item 0: character
\item 1: numeric
\item 2: date
\item 3: posixt (datetime)
\item 4: logical
}

If no type is specified, the column types are derived based on all cells
in a column within the selected data range, excluding potential column
names. If \code{keep_attr} is \code{TRUE}, the derived column types can be inspected
as an attribute of the data frame.

\code{wb_to_df()} will not pick up formulas added to a workbook object
via \code{\link[=wb_add_formula]{wb_add_formula()}}. This is because only the formula is written and left
to be evaluated when the file is opened in a spreadsheet software.
Opening, saving and closing the file in a spreadsheet software will resolve
this.
}
\examples{
###########################################################################
# numerics, dates, missings, bool and string
example_file <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
wb1 <- wb_load(example_file)

# import workbook
wb_to_df(wb1)

# do not convert first row to column names
wb_to_df(wb1, col_names = FALSE)

# do not try to identify dates in the data
wb_to_df(wb1, detect_dates = FALSE)

# return the underlying Excel formula instead of their values
wb_to_df(wb1, show_formula = TRUE)

# read dimension without colNames
wb_to_df(wb1, dims = "A2:C5", col_names = FALSE)

# read selected cols
wb_to_df(wb1, cols = c("A:B", "G"))

# read selected rows
wb_to_df(wb1, rows = c(2, 4, 6))

# convert characters to numerics and date (logical too?)
wb_to_df(wb1, convert = FALSE)

# erase empty rows from dataset
wb_to_df(wb1, skip_empty_rows = TRUE)

# erase empty columns from dataset
wb_to_df(wb1, skip_empty_cols = TRUE)

# convert first row to rownames
wb_to_df(wb1, sheet = 2, dims = "C6:G9", row_names = TRUE)

# define type of the data.frame
wb_to_df(wb1, cols = c(2, 5), types = c("Var1" = 0, "Var3" = 1))

# start in row 5
wb_to_df(wb1, start_row = 5, col_names = FALSE)

# na string
wb_to_df(wb1, na.strings = "a")

###########################################################################
# Named regions
file_named_region <- system.file("extdata", "namedRegions3.xlsx", package = "openxlsx2")
wb2 <- wb_load(file_named_region)

# read dataset with named_region (returns global first)
wb_to_df(wb2, named_region = "MyRange", col_names = FALSE)

# read named_region from sheet
wb_to_df(wb2, named_region = "MyRange", sheet = 4, col_names = FALSE)

# read_xlsx() and wb_read()
example_file <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
read_xlsx(file = example_file)
df1 <- wb_read(file = example_file, sheet = 1)
df2 <- wb_read(file = example_file, sheet = 1, rows = c(1, 3, 5), cols = 1:3)
}
\seealso{
\code{\link[=wb_get_named_regions]{wb_get_named_regions()}}
}
