% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{err_vs_theta0_plot_for_homo_design}
\alias{err_vs_theta0_plot_for_homo_design}
\title{Plots a standard error estimate of thetahat (slope over intercept) over a range of possible theta0 values
in order to investigate robustness of the the initial theta0 guess.}
\usage{
err_vs_theta0_plot_for_homo_design(n, xmin, xmax, theta, theta0_min, theta0_max,
  theta0 = NULL, beta0 = 1, sigma = 1, RES = 500, Nsim = 5000,
  error_est = function(est) {     quantile(est, 0.99) - quantile(est, 0.01) },
  theta_logged = TRUE, error_pct = TRUE, plot_rhos = FALSE, ...)
}
\arguments{
\item{n}{The number of experimental runs.}

\item{xmin}{The minimum value of the independent variable.}

\item{xmax}{The maximum value of the independent variable.}

\item{theta}{The putative true value. This is used to see how much efficiency given up by designing it for \code{theta0}.}

\item{theta0_min}{Simulating over different guesses of theta0, this is the minimum guess.}

\item{theta0_max}{Simulating over different guesses of theta0, this is the maximum guess.}

\item{theta0}{The guess used to construct the experimental design. Specify only if you wish to see this 
value plotted. Default is \code{NULL}.}

\item{beta0}{A guess to be used for the intercept. Defaults to \code{1}.}

\item{sigma}{A guess to be used for the homoskedastic variance of the measurement errors. If known accurately,
then the standard errors (i.e. the y-axis on the plot) will be accurate. Otherwise, the standard
errors are useful only when compared to each other in a relative sense. Defaults to \code{1}.}

\item{RES}{The number of points on the x-axis to simulate. Higher numbers will give smoother results. Default is \code{20}.}

\item{Nsim}{The number of models to be simulated for estimating the standard error at each value on the x-axis. Default is \code{1000}.}

\item{error_est}{The error metric for the estimates. The sample standard deviation (i.e. \code{sd}) 
is unstable at low sample sizes. The default is the 90 percentile minus the 10 percentile.}

\item{theta_logged}{Should the values of theta be logged? Default is \code{TRUE}.}

\item{error_pct}{Plot error as a percentage increase from minimum. Default is \code{TRUE}.}

\item{plot_rhos}{Plot an additional graph of rho by theta0. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the \code{plot} function.}
}
\value{
A list with original parameters as well as data from the simulation
}
\description{
Plots a standard error estimate of thetahat (slope over intercept) over a range of possible theta0 values
in order to investigate robustness of the the initial theta0 guess.
}
\author{
Adam Kapelner
}

