% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_proj.R
\name{optim_proj}
\alias{optim_proj}
\title{Projection plot test.}
\usage{
optim_proj(xsol, fun, maximize = TRUE, xrng = 0.1, npts = 100,
  plot = TRUE, ...)
}
\arguments{
\item{xsol}{Potential solution vector of length \code{nx}.}

\item{fun}{Objective function to be maximized (or minimized), with first argument the length-\code{nx} parameter vector over which optimization is to take place.  Should return a scalar result.}

\item{maximize}{Logical, whether a maximum or a minimum of the objective function is sought.}

\item{xrng}{Optional specification of the range of each projection plot.  Can be: (i) a \code{2 x nx} matrix giving the endpoints of the range, (ii) a scalar or vector of length \code{nx}, such that the range in each plot is \code{theta +/- xrange * abs(theta)}.}

\item{npts}{Number of points in each projection plot.}

\item{plot}{Logical, whether or not to display the projection plots or just return their contents.}

\item{...}{Further arguments to pass to the \code{plot} method (see \code{\link{plot.optproj}}).}
}
\value{
An object of class \code{optproj} inheriting from \code{optcheck} (returned invisibly if \code{plot = TRUE}, with elements:
\describe{
  \item{\code{xsol}}{The potential solution.}
  \item{\code{ysol}}{The value of \code{fun(xsol)}.}
  \item{\code{maximize}}{Logical indicating whether the potential solution should maximize or minimize the objective function.}
  \item{\code{xproj}}{An \code{npts x nx} matrix where each column is the \code{x}-axis of the projection plot along the given component of \code{theta}.}
  \item{\code{yproj}}{An \code{npts x nx} matrix where each column is the \code{y}-axis of the corresponding projection plot.}
}
}
\description{
Given the objective function of an optimization problem and a potential solution, calculates "projection plots" along each coordinate of the solution vector, with all other coordinates being fixed at the input values.
}
\seealso{
\code{plot}, \code{summary}, \code{print}, and \code{diff} methods for projection plots are available; see \code{plot.optproj}, \code{\link{summary.optproj}}, \code{\link{print.optproj}}, and \code{\link{diff.optproj}}.
}
