% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dogleg.R
\name{dogleg}
\alias{dogleg}
\title{Dogleg Trust-Region Optimization}
\usage{
dogleg(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements the standard Powell's Dogleg Trust-Region algorithm for non-linear optimization.
}
\details{
This function implements the classic Dogleg method within a Trust-Region framework, 
based on the strategy proposed by Powell (1970).

\bold{Trust-Region vs. Line Search:}
Trust-Region methods define a neighborhood around the current point (the trust region 
with radius \eqn{\Delta}) where a local quadratic model is assumed to be reliable. 
Unlike Line Search methods that first determine a search direction and then 
find an appropriate step length, this approach constrains the step size first 
and then finds the optimal update within that boundary.

\bold{Powell's Dogleg Trajectory:}
The "Dogleg" trajectory is a piecewise linear path connecting:
\enumerate{
   \item The current point.
   \item The \bold{Cauchy Point} (\eqn{p_C}): The minimizer of the quadratic model along 
         the steepest descent direction.
   \item The \bold{Newton Point} (\eqn{p_N}): The unconstrained minimizer of the quadratic model \eqn{(B^{-1}g)}.
}
The algorithm selects a step along this path such that it minimizes the quadratic 
model while remaining within the radius \eqn{\Delta}.

\bold{Relationship to Double Dogleg:}
While the \code{double_dogleg} algorithm (Dennis and Mei, 1979) introduces a bias 
point to follow the Newton direction more closely, this standard Dogleg follows 
the original two-segment trajectory.
}
\references{
\itemize{
   \item Powell, M. J. D. (1970). A Hybrid Method for Nonlinear Equations. 
         \emph{Numerical Methods for Nonlinear Algebraic Equations}.
   \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
}
}
