% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{lambda}
\alias{lambda}
\title{Lambda}
\usage{
lambda(type = "call", s, x, sigma, t, r, d = 0)
}
\arguments{
\item{type}{Character string, either "call" or "put"}

\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Calculates the Lambda of the option contract
}
\description{
Calculates the Lambda of the call or put option
}
\details{
Lambda, or elasticity is the percentage change in the option valueper percentage change in the underlying price. It is a measure of leverage.
}
\examples{
lambda(type = "put", s = 100, x = 100, sigma = 0.15, t = 45/365, r = 0.02)
}
