% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup.R
\name{orderly_cleanup}
\alias{orderly_cleanup}
\title{Orderly cleanup}
\usage{
orderly_cleanup(name = NULL, root = NULL, locate = TRUE,
  draft = TRUE, data = TRUE, failed_only = FALSE)
}
\arguments{
\item{name}{Optional name; in this case only clean up drafts with this name}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{draft}{Logical, indicating if drafts should be removed}

\item{data}{Logical, indicating if dangling data should be removed
(data not used by any draft or archived report).}

\item{failed_only}{Delete only failed reports (those without the
end-of-run metadata).  This will also clean up drafts created by
\code{\link{orderly_test_start}}}
}
\value{
No return value, this function is called only for its side effects
}
\description{
Clean up orderly draft and data directories.  Deletes all drafts
(possibly just for a set of report names) and then deletes
dangling data sets that are not pointed to by any draft or
committed reports.  Running cleanup does not affect any reports
that have been committed with \code{\link{orderly_commit}} (i.e.,
the contents of the \code{archive/} directory).
}
\examples{
# In a new example orderly, run two reports and commit only the
# second one:
path <- orderly::orderly_example("minimal")
id1 <- orderly::orderly_run("example", root = path)
id2 <- orderly::orderly_run("example", root = path)
orderly::orderly_commit(id2, root = path)

# We now have one draft and one archive report:
orderly::orderly_list_drafts(root = path)
orderly::orderly_list_archive(root = path)

# To clean up the drafts:
orderly::orderly_cleanup(root = path)

# We now have no draft and one archive reports:
orderly::orderly_list_drafts(root = path)
orderly::orderly_list_archive(root = path)
}
