% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_beg.R
\name{order_beg}
\alias{order_beg}
\title{Random Sampling of k-th Order Statistics from a Beta Extended G Distribution}
\usage{
order_beg(size, spec, a, b, k, n, alpha = 0.05, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific G distribution. Possible values "norm", "exp","lnorm","chisq".}

\item{a}{numeric, represents the first shape parameter. Default value is 1.}

\item{b}{numeric, represents the second shape parameter. Default value is 1.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{alpha}{numeric, (1 - alpha) represents the confidence of an interval for the population median of the distribution of the k-th order statistic. Default value is 0.05.}

\item{...}{represents others parameters of the G distribution.}
}
\value{
A list with a random sample of order statistics from a Beta Extended G Distribution, the value of its join probability density function evaluated in the random sample and
a (1 - alpha) confidence interval for the population median of the distribution of the k-th order statistic.
}
\description{
\code{order_beg} is used to obtain a random sample of the k-th order statistic from a Beta Extended G distribution.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Beta Extented Exponential Distribution
order_beg(10,"exp",a=1,b=1,k=3,50,alpha=0.02)
# A sample of size 10 of the 3-th order statistics from a Beta Extented Normal Distribution
order_beg(10,"norm",1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from a Beta Extented Log-normal Distribution
order_beg(10,"lnorm",1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from a Beta Extented Chis-square Distribution
order_beg(10,"chisq",1,1,k=3,50,df=3)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
