% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{matches}
\alias{matches}
\alias{matches.orematches}
\alias{matches.orematch}
\alias{matches.default}
\alias{groups}
\alias{groups.orematches}
\alias{groups.orematch}
\alias{groups.orearg}
\alias{groups.default}
\title{Extract matching substrings}
\usage{
matches(object, ...)

\method{matches}{orematches}(object, simplify = TRUE, ...)

\method{matches}{orematch}(object, ...)

\method{matches}{default}(object, ...)

groups(object, ...)

\method{groups}{orematches}(object, simplify = TRUE, ...)

\method{groups}{orematch}(object, ...)

\method{groups}{orearg}(object, ...)

\method{groups}{default}(object, ...)
}
\arguments{
\item{object}{An R object. Methods are provided for generic lists and
\code{"orematch"} objects. If no object is provided (i.e. the method is
called with no arguments), the value of \code{\link{ore_lastmatch}} will
be used as a default.}

\item{...}{Further arguments to methods.}

\item{simplify}{For the list methods, should nonmatching elements be removed
from the result?}
}
\value{
A vector, matrix, array, or list of the same, containing full
  matches or subgroups. If \code{simplify} is \code{TRUE}, the result may
  have a \code{dropped} attribute, giving the indices of nonmatching
  elements.
}
\description{
These functions extract entire matches, or just subgroup matches, from
objects of class \code{"orematch"}. They can also be applied to lists of
these objects, as returned by \code{\link{ore_search}} when more than one
string is searched. For other objects they return \code{NA}.
}
\seealso{
\code{\link{ore_search}}
}
